/*____________________________________________________________________________
	pgpContext.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	This file contains the definition of the PGPContext data structure and
	prototypes for private context manipulation functions. See pgpUtilities.h
	for public PGPContext manipulation functions

	$Id: pgpContext.h,v 1.15 2001/01/25 22:11:50 jeffc Exp $
____________________________________________________________________________*/

#ifndef Included_pgpContext_h	/* [ */
#define Included_pgpContext_h

#include "pgpMemoryMgr.h"
#include "pgpOpaqueStructs.h"
#include "pgpUtilities.h"
#include "pgpPFLErrors.h"
#include "pgpMemPool.h"

typedef PGPUInt32		PGPConnectRef;
#define kPGPConnectRef_Null		0
#define pgpConnectRefEqual(a,b)	((a) == (b))


PGP_BEGIN_C_DECLARATIONS
#if PRAGMA_IMPORT_SUPPORTED
#pragma import on
#endif

PGPBoolean 	pgpContextIsValid( PGPContextRef context );
#define PGPValidateContext( context )	\
	PGPValidateParam( pgpContextIsValid( context ) )

PGPError 	pgpNewContextCustomInternal(
				PGPCustomContextInfo const *custom,
				PGPContextRef * newContext);
	
PGPEnv *			pgpContextGetEnvironment(PGPContextRef context);
MemPool *			pgpPeekContextMemPool(PGPContextRef context);
PGPMemoryMgrRef		pgpPeekContextMemPoolMgr(PGPContextRef context);

PGPRandomContext *	pgpContextGetGlobalPoolRandomContext(
						PGPContextRef context);
PGPRandomContext *	pgpContextGetDummyRandomContext(PGPContextRef context);
PGPRandomContext *	pgpContextGetX9_17RandomContext(PGPContextRef context);

PGPKeyDBRef			pgpContextGetFirstKeyDB(PGPContextRef context);
void				pgpContextSetFirstKeyDB(PGPContextRef context,
											PGPKeyDBRef keyDB);
PGPBoolean			pgpContextGetUpdateNeeded(PGPContextRef context);
void				pgpContextSetUpdateNeeded(PGPContextRef context,
											PGPBoolean isNeeded);

PGPConnectRef		pgpContextGetConnectRef(PGPContextRef context);
void				pgpContextSetConnectRef(PGPContextRef context,
											PGPConnectRef connect_ref);
PGPUInt32			pgpContextGetThreadID(PGPContextRef context);
struct PGPCacheHeader *pgpContextGetPassphraseCache(PGPContextRef context);
void				pgpContextSetPassphraseCache(PGPContextRef context,
									struct PGPCacheHeader * passphraseCache);
PGPContextRef		pgpContextNextContext( PGPContextRef context );

void				pgpCallNotificationCallback(void);
								
/* memory allocation and deallocation */
void  *		pgpContextMemAlloc( PGPContextRef context,
					PGPSize allocationSize, PGPMemoryMgrFlags flags );
void  *		PGPContextMemAllocCopy( PGPContextRef context,
					PGPSize allocationSize, PGPMemoryMgrFlags flags,
					const void *dataToCopy);
PGPError 	pgpContextMemRealloc( PGPContextRef context,
					void **allocation, PGPSize newAllocationSize,
					PGPMemoryMgrFlags flags );
PGPError 	pgpContextMemFree( PGPContextRef context,
					void *allocation );

/* Lightweight, mempool based allocation and deallocation */
void  *		pgpContextMemPoolAlloc( PGPContextRef context,
					PGPSize allocationSize, PGPMemoryMgrFlags flags );
PGPError 	pgpContextMemPoolRealloc( PGPContextRef context,
					void **allocation, PGPSize newAllocationSize,
					PGPMemoryMgrFlags flags );
void		pgpContextMemPoolCutBack( PGPContextRef context,
					MemPool const *cutpool );

					
#if PRAGMA_IMPORT_SUPPORTED
#pragma import reset
#endif
PGP_END_C_DECLARATIONS

#endif /* ] Included_pgpContext_h */

/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
